{extends file="layouts/credit.tpl"}

{block name=contents}

<div class="pagination-area bg-secondary">
    <div class="container">
        <div class="pagination-wrapper">
            <ul>
                <li><a href="{$url.main}">Home</a><span> -</span></li>
                <li>Buy Credit</li>
            </ul>
        </div>
    </div>  
</div>
{$form_alert}

<div class="trending-products-area bg-secondary section-space-default">                
    <div class="container">
        <h2 class="title-default pro-title"> Choose Credit Package </h2>  
    </div>
    <div class="container-fluid" id="isotope-container">
        <div class="row featuredContainers">
            {if $packs}
            <div class="container">
                <div class="row">

                    {foreach from=$packs item=$pack}
                    <div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
                        <div class="panel text-center price-panel panel-{$pack->pack_color}">
                            <div class="panel-heading">
                            <h3>{$pack->pack_name}</h3>
                            </div>
                            <div class="panel-body">
                            <p class="lead big-lead"><strong>{$app.currency} {$pack->pack_price}</strong></p>
                            </div>
                            <ul class="list-group">
                            <li class="list-group-item"><i class="fa fa-check text-success"></i> INstantly Credited</li>
                            <li class="list-group-item"><i class="fa fa-check  text-success"></i> No Extra Charges</li>
                            </ul>
                            <div class="panel-footer">
                            <a href="#buyCredit{$pack->pack_id}" data-toggle="modal" class="btn btn-lg btn-block btn-{if $pack->pack_color eq 'grey'}default{elseif $pack->pack_color eq 'blue'}primary{elseif $pack->pack_color eq 'red'}danger{elseif $pack->pack_color eq 'green'}success{/if}">BUY NOW!</a>
                            </div>
                        </div>
                    </div>
                    {/foreach}

                    


                </div>
            </div>
            {/if}

        </div>
    </div>
</div>

{if $packs}
    {foreach from=$packs item=$pack}
        <!-- Modal -->
        <div class="modal fade" id="buyCredit{$pack->pack_id}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Purchase {$pack->pack_name}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="">
                    <div class="row">
                        <div class="paymentCont">
                            <div class="headingWrap">
                                    <h3 class="headingTop text-center">Select Your Payment Method</h3>	
                                    <p class="text-center">Purchasing <strong>{$pack->pack_name}</strong> For {$app.currency}{$pack->pack_price}</p>
                            </div>
                            

                            <div class="row">
                                {if $paypal->pg_status eq 1}
                                <div class="{if $stripe->sg_status != 1}col-md-12 col-xs-12 col-sm-12{else}col-md-6 col-xs-6 col-sm-6{/if}">
                                    <center><div id="paypal-button{$pack->pack_id}"></div></center>
                                </div>
                                {/if}

                                {if $stripe->sg_status eq 1}
                                <div class="{if $paypal->pg_status != 1}col-md-12 col-xs-12 col-sm-12{else}col-md-6 col-xs-6 col-sm-6{/if}">
                                    <div id="buynow{$pack->pack_id}">
                                        <button class="btn btn-success btn-block btn-rounded stripe-button" id="payButton{$pack->pack_id}">Pay With Stripe</button>
                                        <input type="hidden" id="payProcess{$pack->pack_id}" value="0"/>
                                    </div>
                                </div>
                                {/if}
                                </div>

                                <div class="row">

                                <div class="col-md-12 text-center">
                                    <div id="paymentDetails{$pack->pack_id}" style="display: none;">
                                        <p class="aligncenter green bigger">Your payment was successful.</p>
                                        <h4 class="text-center">Payment Information</h4>
                                        <p>
                                        Order ID: <span class="text-center" id="orderID{$pack->pack_id}">&#x3C;ORDER_ID&#x3E;</span><br/>
                                        Transaction ID: <span class="text-center" id="txnID{$pack->pack_id}">&#x3C;TX_ID&#x3E;</span><br/>
                                        </p>
                                        <a href="{$url.main}buy-credit" type="button" class="btn btn-success btn-block">Click Here If Not Redirected</a>
                                    </div>
                                </div>

                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
            </div>
            </div>
        </div>
        </div>







        <script src="https://www.paypalobjects.com/api/checkout.js"></script>

        <script>
        {literal}
        paypal.Button.render({
            // Configure environment
            env: '{/literal}{$env}{literal}',
            client: {
                sandbox: '{/literal}{$sandbox}{literal}',
                production: '{/literal}{$production}{literal}'
            },
            // Customize button (optional)
            locale: 'en_US',
            style: {
                size: 'responsive',
                color: 'gold',
                shape: 'pill',
                label: 'buynow',
                tagline: 'true',
                fundingicons: 'true',
            },
            // Set up a payment
            payment: function (data, actions) {
                return actions.payment.create({
                transactions: [
                    {
                        amount: { total: '{/literal}{$pack->pack_price}', currency: '{$app.currency_code}{literal}' },
                        item_list: {
                            items: [
                                {
                                name: '{/literal}{$pack->pack_name} Credit Package',
                                description: 'Purchase {$pack->pack_name} Credit Package',
                                quantity: '1',
                                price: '{$pack->pack_price}',
                                currency: '{$app.currency_code}' {literal}
                                }
                            ]
                        }
                    }
                ]
            });
            },
            // Execute the payment
            onAuthorize: function (data, actions) {
                return actions.payment.execute()
                .then(function () {
                    // Show a confirmation message to the buyer
                    //window.alert('Thank you for your purchase!');
                    
                    // Redirect to the payment process page
                    window.location = "{/literal}{$url.main}{literal}checkout/process_credit_purchase?paymentID="+data.paymentID+"&token="+data.paymentToken+"&payerID="+data.payerID+"&itd={/literal}{$pack->pack_id}{literal}&pay_method=paypal";
                });
            }
        }, '#paypal-button{/literal}{$pack->pack_id}{literal}');
        {/literal}
        </script>

        <script type="text/javascript">

        $("#paypal-button{$pack->pack_id}").trigger('click');

        </script>

        <script>
        {literal}
            
        var handler = StripeCheckout.configure({
            key: '{/literal}{$publishable_key}',
            image: '{$app.logo}{literal}',
            locale: 'auto',
            token: function(token) {
                // You can access the token ID with `token.id`.
                // Get the token ID to your server-side code for use.
                
                $('#paymentDetails{/literal}{$pack->pack_id}').hide();
                $('#payProcess{$pack->pack_id}{literal}').val(1);
                $.ajax({
                    url: '{/literal}{$url.main}checkout/stripe_process_purchase_credit{literal}',
                    type: 'POST',
                    data: {_token: '{/literal}{$csrf_value}', item_id: {$pack->pack_id}{literal}, stripeToken: token.id, stripeEmail: token.email, itemName: '{/literal}{$pack->pack_name}', itemPrice: {$pack->pack_price}{'00'}, currency: '{$app.currency_code|strtolower}{literal}'},
                    dataType: "json",
                    beforeSend: function(){
                        $('#payButton{/literal}{$pack->pack_id}').prop('disabled', true);
                        $('#payButton{$pack->pack_id}{literal}').html('Please wait...');
                    },
                    success: function(data){
                        $('#payProcess{/literal}{$pack->pack_id}{literal}').val(0);
                        if(data.status == 1){
                            $('#buynow{/literal}{$pack->pack_id}{literal}').hide();
                            $('#txnEmail{/literal}{$pack->pack_id}{literal}').html(token.email);
                            $('#orderID{/literal}{$pack->pack_id}{literal}').html(data.txnData.id);
                            $('#txnID{/literal}{$pack->pack_id}{literal}').html(data.txnData.balance_transaction);
                            $('#paymentDetails{/literal}{$pack->pack_id}{literal}').show();
                        }else {
                            $('#payButton{/literal}{$pack->pack_id}{literal}').prop('disabled', false);
                            $('#payButton{/literal}{$pack->pack_id}{literal}').html('Buy Now');
                            alert('Some problem occurred, please try again.');
                        }
                    },
                    error: function(data) {
                        $('#payProcess{/literal}{$pack->pack_id}{literal}').val(0);
                        $('#payButton{/literal}{$pack->pack_id}{literal}').prop('disabled', false);
                        $('#payButton{/literal}{$pack->pack_id}{literal}').html('Buy Now');
                        alert('Some problem occurred, please try again but paid.');
                    }
                });
            }
        });

        var stripe_closed = function(){
            var processing = $('#payProcess{/literal}{$pack->pack_id}{literal}').val();
            if (processing == 0){
                $('#payButton{/literal}{$pack->pack_id}{literal}').prop('disabled', false);
                $('#payButton{/literal}{$pack->pack_id}{literal}').html('Pay With Stripe');
            }
        };

        var eventTggr = document.getElementById('payButton{/literal}{$pack->pack_id}{literal}');
        if(eventTggr){
            eventTggr.addEventListener('click', function(e) {
                $('#payButton{/literal}{$pack->pack_id}{literal}').prop('disabled', true);
                $('#payButton{/literal}{$pack->pack_id}{literal}').html('Please wait...');
                
                // Open Checkout with further options:
                handler.open({
                    name: '{/literal}{$app.name}',
                    description: 'Purchase {$pack->pack_name} Credit Package From {$app.name}',
                    amount: {$pack->pack_price}{'00'},
                    currency: '{$app.currency_code|strtolower}{literal}',
                    closed:	stripe_closed
                });
                e.preventDefault();
            });
        }

        // Close Checkout on page navigation:
        window.addEventListener('popstate', function() {
        handler.close();
        });


        {/literal}

        </script>


    {/foreach}
{/if}
    
{/block}

{block name=credit_style}
{literal}
    <style>
        .big-lead {
            font-size: 40px;
        }

        .price-panel,
        .price-panel > .panel-heading {
            -webkit-transition: all .3s ease;
            -moz-transition: all .3s ease;
            -o-transition: all .3s ease;
            transition: all .3s ease;
        }

        .price-panel:hover {
            box-shadow: 0 0 30px rgba(0,0,0, .2);
        }
        .price-panel:hover > .panel-heading {
            box-shadow: 0 0 30px rgba(0,0,0, .2) inset;
        }

        .price-panel > .panel-heading {
            color: white;
            text-shadow: 0 3px 0 rgba(50,50,50, .6);
            border-radius: 0;
            box-shadow: 0 5px 0 rgba(50,50,50, .2) inset;
        }
        .price-panel > .panel-body {
            color: white;
            text-shadow: 0 3px 0 rgba(50,50,50, .3);
        }
        .price-panel > .list-group {
            font-weight: 600;
        }
        .price-panel > .panel-footer {
            box-shadow: 0 3px 0 rgba(0,0,0, .3);
        }

        .panel-grey > .panel-heading {
            background-color: #6d6d6d;
            border-color: #b7b7b7;
        }
        .panel-grey > .panel-body {
            background-color: #808080;
        }

        .panel-blue > .panel-heading {
            background-color: #608bb4;
            border-color: #78aee1;
        }
        .panel-blue > .panel-body {
            background-color: #73a3d4;
        }

        .panel-green > .panel-heading {
            background-color: #57ac57;
            border-color: #71df71;
        }
        .panel-green > .panel-body {
            background-color: #65c965;
        }

        .panel-red > .panel-heading {
            background-color: #d04e50;
            border-color: #ff6062;
        }
        .panel-red > .panel-body {
            background-color: #ef5a5c;
        }
    </style>
{/literal}
{/block}

{block name=stripe_js}
<script src="https://checkout.stripe.com/checkout.js"></script>
{/block}